<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Kit;
use Elementor\Core\Kits\Documents\Tabs\Tab_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Liquid_Global_Portfolio extends Tab_Base {

	public function __construct( $parent ) {
		parent::__construct( $parent );

		Controls_Manager::add_tab( $this->get_id(), $this->get_title() );
	}

	public function get_id() {
		return 'liquid-portfolio-kit';
	}

	public function get_title() {
		return __( 'Portfolio', 'logistics-hub-core' );
	}

	public function get_group() {
		return 'settings';
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_help_url() {
		return 'https://docs.liquid-themes.com/';
	}

	protected function register_tab_controls() {

		$this->start_controls_section(
			'section_' . $this->get_id() . '_archives',
			[
				'label' => esc_html__('General Portfolio Archives', 'logistics-hub-core'),
				'tab' => $this->get_id(),
			]
		);

		$this->add_control(
			'liquid_portfolio_single_slug',
			[
				'label' => esc_html__( 'Portfolio slug', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'myslug', 'logistics-hub-core' ),
				'description' => esc_html__( 'After saving your custom portfolio slug, flush the permalinks from "Wordpress Settings > Permalinks" for the changes to take effect.', 'logistics-hub-core' ),
			]
		);

		$this->add_control(
			'liquid_portfolio_category_slug',
			[
				'label' => esc_html__( 'Portfolio category slug', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'myslug', 'logistics-hub-core' ),
				'description' => esc_html__( 'After saving your custom portfolio slug, flush the permalinks from "Wordpress Settings > Permalinks" for the changes to take effect.', 'logistics-hub-core' ),
			]
		);

		$this->end_controls_section();

	}

}

new Liquid_Global_Portfolio( Kit::class );

add_action(
	'elementor/kit/register_tabs',
	function( $kit ) {
		$kit->register_tab( 'liquid-portfolio-kit', Liquid_Global_Portfolio::class );
	}
);
